/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.ConfigLoader;
import frc.emul.config.ConfigSaver;
import frc.emul.config.IndentedPrinter;
import frc.emul.config.data.CfgItemKernel;
import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.config.handler.ShaderLoaderContext;
import frc.emul.util.Utils;
import frc.emul.util.swing.FileRequester;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.icons.JVEIcons;
import frc.emul.vectrex.ui.opengl.BlurShaderUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.XMLReader;

public abstract class UIGlowShaderSettings {
    private int eventsLock;
    private boolean hasBeenModified;
    private CfgItemShaderGlow editedShader;
    private CfgItemShaderGlow modelShader;
    private JButton bUndo;
    private JButton bOK;
    private JTextArea taDescription;
    private JSpinner spPasses;
    private JCheckBox cbGainH;
    private JCheckBox cbGainV;
    private JSpinner spGainH;
    private JSpinner spGainV;
    private JCheckBox cbFlicker;
    private JSlider sFlicker;
    private JCheckBox cbAttenuation;
    private JSlider sAttenuation;
    private JComboBox cbMode;
    private JSlider sFactor;
    private JCheckBox cbAspect;
    private JSpinner spWidth;
    private JSpinner spHeight;
    private JComboBox cbKernelPattern;
    private JSpinner spKernelParam;
    private JCheckBox cbLinkKernels;
    private KernelTableModel[] kernelModels = new KernelTableModel[2];
    private JComboBox[] cbKernelSizes = new JComboBox[2];
    private static final String SHADERFOLDER_SPECIAL = "Special";
    private static final String SHADERNAME_CURRENT = "Initial Shader";
    private static final String SHADERNAME_DEFAULT = "Default Shader";
    private static final String INVALID_DESCRIPTION = "No profile selected";
    private static final String DEFAULT_DESCRIPTION = "Description of the shader...";
    private static FileRequester profileReq;
    private static Window currentWin;
    private static final String[] KERNEL_SIZES;

    static {
        KERNEL_SIZES = new String[25];
        int n = 0;
        while (n < KERNEL_SIZES.length) {
            UIGlowShaderSettings.KERNEL_SIZES[n] = " " + (n * 2 + 1) + " ";
            ++n;
        }
    }

    protected abstract void windowClosed();

    protected abstract void shaderAccepted(CfgItemShaderGlow var1);

    protected abstract void shaderChanged(CfgItemShaderGlow var1);

    public UIGlowShaderSettings(CfgItemShaderGlow cfgItemShaderGlow) {
        this.modelShader = new CfgItemShaderGlow(cfgItemShaderGlow, false);
    }

    public synchronized boolean isOpened() {
        return currentWin != null && currentWin.isVisible();
    }

    public synchronized void openSelector(Window window, CfgItemShaderGlow cfgItemShaderGlow) {
        JDialog jDialog = this.createWindow(window, "ParaJVE - Glow Shader Profile Selector");
        if (jDialog == null) {
            return;
        }
        this.openWindow(jDialog, this.buildSelectorMainPane(cfgItemShaderGlow), true, "OK", false, " Keep the selected profile settings ", " Restore the original settings ");
    }

    public synchronized void openEditor(Window window) {
        JDialog jDialog = this.createWindow(window, "ParaJVE - Glow Shader Settings");
        if (jDialog == null) {
            return;
        }
        JComponent jComponent = this.buildMainProfilesPanel();
        JComponent jComponent2 = this.buildMainGeneralPanel();
        JComponent jComponent3 = this.buildMainBufferPanel();
        JComponent jComponent4 = this.buildMainKernelsPanel();
        JComponent jComponent5 = this.buildMainInfosPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(" Profiles ", jComponent);
        jTabbedPane.addTab(" General ", jComponent2);
        jTabbedPane.addTab(" Buffer ", jComponent3);
        jTabbedPane.addTab(" Kernels ", jComponent4);
        jTabbedPane.addTab(" Description ", jComponent5);
        jTabbedPane.setSelectedComponent(jComponent);
        this.openWindow(jDialog, jTabbedPane, true, "OK", true, " Save the current settings ", " Discard the changes made to the settings ");
    }

    private JDialog createWindow(Window window, String string) {
        if (this.isOpened()) {
            currentWin.toFront();
            currentWin.requestFocus();
            return null;
        }
        JDialog jDialog = UIUtils.createDialog(window, string, false);
        jDialog.setDefaultCloseOperation(2);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (currentWin == windowEvent.getWindow()) {
                    currentWin = null;
                }
                UIGlowShaderSettings.this.windowClosed();
            }
        });
        this.editedShader = new CfgItemShaderGlow(this.modelShader, false);
        currentWin = jDialog;
        return jDialog;
    }

    private void openWindow(final JDialog jDialog, JComponent jComponent, boolean bl, String string, boolean bl2, String string2, String string3) {
        JPanel jPanel = new JPanel(new FlowLayout(2, 1, 0));
        JButton jButton = new JButton(string);
        JButton jButton2 = new JButton("Cancel");
        this.bOK = jButton;
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIGlowShaderSettings.this.hasBeenModified()) {
                    UIGlowShaderSettings.this.shaderAccepted(UIGlowShaderSettings.this.editedShader);
                }
                jDialog.dispose();
            }
        });
        UIUtils.registerEscapeButton(jButton2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGlowShaderSettings.this.resetEditedShader(UIGlowShaderSettings.this.modelShader);
                jDialog.dispose();
            }
        });
        jButton.setEnabled(bl2);
        jButton.setToolTipText(string2);
        jButton2.setToolTipText(string3);
        this.setModified(false);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        container.add((Component)jComponent, "Center");
        container.add((Component)jPanel, "South");
        UIUtils.setContainerBorder(container);
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.setResizable(bl);
        jDialog.setVisible(true);
    }

    private void resetEditedShader(CfgItemShaderGlow cfgItemShaderGlow) {
        boolean bl;
        boolean bl2 = bl = cfgItemShaderGlow == this.modelShader;
        if (this.hasBeenModified() || !bl) {
            this.editedShader.clone(cfgItemShaderGlow, false);
            this.fireShaderChanged();
            this.setModified(!bl);
        }
    }

    private void loadUI() {
        CfgItemShaderGlow cfgItemShaderGlow = this.editedShader;
        this.lockEvents();
        try {
            this.spPasses.setValue(cfgItemShaderGlow.passes);
            UIGlowShaderSettings.updateCheckBox(this.cbGainH, cfgItemShaderGlow.hGain);
            this.spGainH.setValue(Float.valueOf(cfgItemShaderGlow.hGainFactor));
            UIGlowShaderSettings.updateCheckBox(this.cbGainV, cfgItemShaderGlow.vGain);
            this.spGainV.setValue(Float.valueOf(cfgItemShaderGlow.vGainFactor));
            UIGlowShaderSettings.updateCheckBox(this.cbFlicker, cfgItemShaderGlow.flickering);
            this.sFlicker.setValue((int)(cfgItemShaderGlow.flickeringFactor * 1000.0f));
            UIGlowShaderSettings.updateCheckBox(this.cbAttenuation, cfgItemShaderGlow.attenuation);
            this.sAttenuation.setValue((int)(cfgItemShaderGlow.attenuationFactor * 1000.0f));
            this.sFactor.setValue((int)(cfgItemShaderGlow.bufferSizeFactor * 1000.0f));
            this.spWidth.setValue(cfgItemShaderGlow.bufferFixedWidth);
            this.spHeight.setValue(cfgItemShaderGlow.bufferFixedHeight);
            this.cbAspect.setSelected(UIGlowShaderSettings.isFixedBufferVectrexRatio(cfgItemShaderGlow));
            this.cbMode.setSelectedIndex(cfgItemShaderGlow.isBufferFixedSize ? 0 : 1);
            this.taDescription.setText(UIGlowShaderSettings.getShaderDescription(cfgItemShaderGlow.description));
            CfgItemKernel[] cfgItemKernelArray = new CfgItemKernel[]{cfgItemShaderGlow.getHorizonalKernel(), cfgItemShaderGlow.getVerticalKernel()};
            boolean bl = Arrays.equals(cfgItemKernelArray[0].getHalfMatrix(), cfgItemKernelArray[1].getHalfMatrix());
            UIGlowShaderSettings.updateCheckBox(this.cbLinkKernels, bl);
            int n = 0;
            while (n < 2) {
                this.cbKernelSizes[n].setSelectedIndex(cfgItemKernelArray[n].getHalfSize() - 1);
                this.kernelModels[n].setKernel(cfgItemKernelArray[n]);
                ++n;
            }
        }
        finally {
            this.unlockEvents();
        }
    }

    private static void saveShader(CfgItemShaderGlow cfgItemShaderGlow, File file) throws Exception {
        PrintStream printStream = null;
        try {
            file.getParentFile().mkdirs();
            printStream = new PrintStream(file);
            IndentedPrinter indentedPrinter = new IndentedPrinter(printStream);
            ConfigSaver.saveXmlHeader(indentedPrinter);
            ConfigSaver.saveGlowShader(cfgItemShaderGlow, indentedPrinter, true);
        }
        catch (Throwable throwable) {
            if (printStream != null) {
                try {
                    printStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (printStream != null) {
            try {
                printStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static CfgItemShaderGlow loadShader(File file) throws Exception {
        CfgItemShaderGlow cfgItemShaderGlow;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                ShaderLoaderContext shaderLoaderContext = new ShaderLoaderContext(xMLReader);
                xMLReader.setErrorHandler(null);
                xMLReader.parse(ConfigLoader.openInputSource(fileInputStream));
                cfgItemShaderGlow = shaderLoaderContext.getRootShader();
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
        }
        return cfgItemShaderGlow;
    }

    /*
     * WARNING - void declaration
     */
    private static void gatherValidShadersTree(DefaultMutableTreeNode defaultMutableTreeNode, File file, CfgItemShaderGlow cfgItemShaderGlow) {
        Object object;
        void cfgItemShaderGlow3;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        boolean n2 = false;
        while (cfgItemShaderGlow3 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            object = fileArray2[cfgItemShaderGlow3];
            if (((File)object).isDirectory()) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(file.getName(), true);
                UIGlowShaderSettings.gatherValidShadersTree(defaultMutableTreeNode2, (File)object, null);
                if (defaultMutableTreeNode2.getChildCount() > 0) {
                    arrayList.add(defaultMutableTreeNode2);
                }
            } else if (((File)object).isFile()) {
                try {
                    CfgItemShaderGlow cfgItemShaderGlow2 = UIGlowShaderSettings.loadShader((File)object);
                    if (cfgItemShaderGlow2 != null) {
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListItemShader((File)object, cfgItemShaderGlow2), false);
                        arrayList2.add(defaultMutableTreeNode2);
                    }
                }
                catch (Exception exception) {}
            }
            ++cfgItemShaderGlow3;
        }
        if (cfgItemShaderGlow != null) {
            object = new CfgItemShaderGlow(cfgItemShaderGlow, true);
            CfgItemShaderGlow mutableTreeNode = new CfgItemShaderGlow();
            ((CfgItemShaderGlow)object).description = "The shader that was in use when this window opened.";
            mutableTreeNode.description = "A generic shader, initialized with the default settings.";
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(SHADERFOLDER_SPECIAL, true);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new ListItemShader(SHADERNAME_CURRENT, (CfgItemShaderGlow)object), false));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new ListItemShader(SHADERNAME_DEFAULT, mutableTreeNode), false));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
        object = new Comparator<MutableTreeNode>(){

            @Override
            public int compare(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
                return mutableTreeNode.toString().compareToIgnoreCase(mutableTreeNode2.toString());
            }
        };
        Collections.sort(arrayList, object);
        Collections.sort(arrayList2, object);
        for (MutableTreeNode mutableTreeNode : arrayList) {
            defaultMutableTreeNode.add(mutableTreeNode);
        }
        for (MutableTreeNode mutableTreeNode : arrayList2) {
            defaultMutableTreeNode.add(mutableTreeNode);
        }
    }

    public synchronized JComponent buildSelectorMainPane(CfgItemShaderGlow cfgItemShaderGlow) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("ROOT", true);
        UIGlowShaderSettings.gatherValidShadersTree(defaultMutableTreeNode, new File("data/shaders/"), cfgItemShaderGlow);
        if (defaultMutableTreeNode.getChildCount() == 0) {
            JLabel jLabel = new JLabel("<html><b>Could not find any valid Glow Shader Profile !");
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(new EmptyBorder(15, 30, 15, 30));
            Toolkit.getDefaultToolkit().beep();
            return jLabel;
        }
        final JTree jTree = new JTree(defaultMutableTreeNode, true);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setVisibleRowCount(18);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(defaultMutableTreeNode.getChildCount() > 0 && !defaultMutableTreeNode.getChildAt(0).isLeaf());
        jTree.setCellRenderer(new TreeShaderRenderer());
        jTree.expandRow(0);
        jTree.setSelectionRow(1);
        JComponent[] jComponentArray = new JComponent[1];
        JComponent jComponent = UIGlowShaderSettings.createInfoPreview(jTree, jComponentArray, 300);
        final JTextComponent jTextComponent = (JTextComponent)jComponentArray[0];
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                CfgItemShaderGlow cfgItemShaderGlow;
                DefaultMutableTreeNode defaultMutableTreeNode;
                TreePath treePath = jTree.getSelectionPath();
                if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null && defaultMutableTreeNode.isLeaf() && (cfgItemShaderGlow = ((ListItemShader)defaultMutableTreeNode.getUserObject()).getShader()) != UIGlowShaderSettings.this.editedShader) {
                    UIGlowShaderSettings.updatePreview(jTextComponent, cfgItemShaderGlow);
                    UIGlowShaderSettings.this.editedShader = cfgItemShaderGlow;
                    if (treeSelectionEvent != null) {
                        UIGlowShaderSettings.this.fireShaderChanged();
                    }
                }
            }
        };
        treeSelectionListener.valueChanged(null);
        jTree.addTreeSelectionListener(treeSelectionListener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(jTree), "Center");
        jPanel.add((Component)jComponent, "East");
        return jPanel;
    }

    private JComponent buildMainProfilesPanel() {
        JButton jButton = new JButton("<html><b>Save</b> settings as Profile...");
        JButton jButton2 = new JButton("<html><b>Load</b> settings from Profile...");
        JButton jButton3 = new JButton("<html><font color=#FF0000><b>Delete</b></font> an existing Profile...");
        JButton jButton4 = new JButton("<html>Reset to <b>default</b> settings");
        this.bUndo = new JButton("Undo Changes");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel.add(this.bUndo);
        jPanel.add(jButton4);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
        Borders.setTitleBorder(jPanel2, "Profiles");
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel2.add(jButton3);
        jPanel2 = UIGlowShaderSettings.embed(jPanel2);
        jPanel2.setBorder(new EmptyBorder(15, 20, 20, 20));
        jPanel2.add((Component)jPanel, "South");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGlowShaderSettings.this.resetEditedShader(new CfgItemShaderGlow());
                UIGlowShaderSettings.this.loadUI();
            }
        });
        this.bUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGlowShaderSettings.this.resetEditedShader(UIGlowShaderSettings.this.modelShader);
                UIGlowShaderSettings.this.loadUI();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileRequester fileRequester = UIGlowShaderSettings.getProfileChooser();
                File file = fileRequester.requestSave(currentWin, "Save shader settings in profile...", ".glow");
                if (file == null) {
                    return;
                }
                try {
                    ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.description = UIGlowShaderSettings.readShaderDescription(UIGlowShaderSettings.this.taDescription.getText());
                    UIGlowShaderSettings.saveShader(UIGlowShaderSettings.this.editedShader, file);
                    JOptionPane.showMessageDialog(currentWin, "Shader profile successfully saved.", "ParaJVE", 1);
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(currentWin, "<html><center>&nbsp;Failed to save shader profile to file&nbsp;<br><b>&nbsp;" + Utils.getRelativePath(file) + "&nbsp;", "ParaJVE", 0);
                    System.out.println("*** Cannot save shader profile to [" + file.getPath() + "] :");
                    throwable.printStackTrace(System.out);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileRequester fileRequester = UIGlowShaderSettings.getProfileChooser();
                File file = fileRequester.requestOpen(currentWin, "Load shader settings from profile...");
                if (file == null) {
                    return;
                }
                CfgItemShaderGlow cfgItemShaderGlow = null;
                try {
                    cfgItemShaderGlow = UIGlowShaderSettings.loadShader(file);
                }
                catch (Throwable throwable) {
                    System.out.println("*** Cannot load shader profile from [" + file.getPath() + "] :");
                    throwable.printStackTrace(System.out);
                }
                if (cfgItemShaderGlow == null) {
                    JOptionPane.showMessageDialog(currentWin, "<html><center>&nbsp;Failed to load shader profile from file&nbsp;<br><b>&nbsp;" + Utils.getRelativePath(file) + "&nbsp;", "ParaJVE", 0);
                    return;
                }
                UIGlowShaderSettings.this.editedShader.clone(cfgItemShaderGlow, false);
                UIGlowShaderSettings.this.loadUI();
                UIGlowShaderSettings.this.fireShaderChanged();
                JOptionPane.showMessageDialog(currentWin, "Shader profile successfully loaded.", "ParaJVE", 1);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileRequester fileRequester = UIGlowShaderSettings.getProfileChooser();
                File file = fileRequester.requestDelete(currentWin, "Delete a shader profile...");
                if (file != null) {
                    String string = "<html>Do you really want to <b><font color=#FF0000>delete</font></b> this shader profile?<br><br><b>" + Utils.getRelativePath(file) + "<br>&nbsp;";
                    int n = JOptionPane.showConfirmDialog(currentWin, string, "ParaJVE - Delete Profile...", 0);
                    if (n == 0) {
                        if (file.delete()) {
                            JOptionPane.showMessageDialog(currentWin, "Shader profile successfully deleted.", "ParaJVE", 1);
                        } else {
                            JOptionPane.showMessageDialog(currentWin, "Could not delete the specified profile!", "ParaJVE", 0);
                        }
                    }
                }
            }
        });
        return jPanel2;
    }

    private JComponent buildMainInfosPanel() {
        JComponent[] jComponentArray = new JComponent[1];
        JComponent jComponent = UIGlowShaderSettings.buildMainInfosPanel(true, jComponentArray);
        this.taDescription = (JTextArea)jComponentArray[0];
        this.taDescription.setText(UIGlowShaderSettings.getShaderDescription(this.editedShader.description));
        return jComponent;
    }

    private static JComponent buildMainInfosPanel(boolean bl, JComponent[] jComponentArray) {
        JTextComponent jTextComponent;
        String string = UIGlowShaderSettings.getShaderDescription("");
        JTextComponent jTextComponent2 = jTextComponent = bl ? new JTextArea(string) : new JEditorPane("text/html", string);
        if (jTextComponent instanceof JTextArea) {
            ((JTextArea)jTextComponent).setLineWrap(true);
            ((JTextArea)jTextComponent).setWrapStyleWord(true);
        }
        jTextComponent.setOpaque(bl);
        jTextComponent.setEditable(bl);
        JScrollPane jScrollPane = new JScrollPane(jTextComponent, 20, 31);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.add(jScrollPane);
        if (bl) {
            jTextComponent.setMargin(new Insets(1, 3, 1, 3));
            jPanel.setBorder(Borders.EMPTY_10);
        } else {
            jTextComponent.setOpaque(true);
            jTextComponent.setMargin(new Insets(3, 4, 3, 4));
            jPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        }
        jComponentArray[0] = jTextComponent;
        return jPanel;
    }

    private JComponent buildMainGeneralPanel() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(new EmptyBorder(15, 20, 20, 20));
        jPanel.add(this.buildSubPane_general_passes());
        jPanel.add(this.buildSubPane_general_brightnessGains());
        jPanel.add(this.buildSubPane_general_brightnessFlickering());
        jPanel.add(this.buildSubPane_general_persistenceAttenuation());
        UIUtils.makeCompactGrid(jPanel, 1, 0, 0, 10, 10);
        return UIGlowShaderSettings.embed(jPanel);
    }

    private JComponent buildSubPane_general_passes() {
        this.spPasses = new JSpinnerFix(new SpinnerNumberModel(this.editedShader.passes, 1, 30, 1));
        Box box = Box.createHorizontalBox();
        UIGlowShaderSettings.addHorizontalGlues(box, 4);
        box.add(new JLabel("Shader passes (glow spreading)"));
        box.add(Box.createHorizontalStrut(10));
        box.add(this.spPasses);
        UIGlowShaderSettings.addHorizontalGlues(box, 4);
        this.spPasses.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.passes = ((Number)UIGlowShaderSettings.this.spPasses.getValue()).intValue();
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
        box.setBorder(new CompoundBorder(new TitledBorder(" Overall Settings "), new EmptyBorder(4, 0, 10, 0)));
        return box;
    }

    private JComponent buildSubPane_general_brightnessGains() {
        this.cbGainH = new JCheckBox("During Horinzontal processing", this.editedShader.hGain);
        this.cbGainH.setBorder(null);
        this.cbGainH.setFocusPainted(false);
        this.cbGainV = new JCheckBox("During Vertical processing", this.editedShader.vGain);
        this.cbGainV.setBorder(null);
        this.cbGainV.setFocusPainted(false);
        this.spGainH = new JSpinnerFix(new SpinnerNumberModel(this.editedShader.hGainFactor, 0.005, 50.0, 0.05));
        this.spGainV = new JSpinnerFix(new SpinnerNumberModel(this.editedShader.vGainFactor, 0.005, 50.0, 0.05));
        UIUtils.linkComponents(this.cbGainH, this.spGainH, true);
        UIUtils.linkComponents(this.cbGainV, this.spGainV, true);
        this.attachCheckBox(this.cbGainH, "hGain");
        this.attachCheckBox(this.cbGainV, "vGain");
        this.spGainH.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.hGainFactor = ((Number)((JSpinner)changeEvent.getSource()).getValue()).floatValue();
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
        this.spGainV.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.vGainFactor = ((Number)((JSpinner)changeEvent.getSource()).getValue()).floatValue();
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
        JPanel jPanel = new JPanel(new SpringLayout());
        Borders.setTitleBorder(jPanel, " Brightness Gain Factor ");
        jPanel.add(this.cbGainH);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.spGainH);
        jPanel.add(this.cbGainV);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.spGainV);
        UIUtils.makeCompactGrid(jPanel, 3, 0, 0, 10, 10);
        return jPanel;
    }

    private JComponent buildSubPane_general_brightnessFlickering() {
        this.cbFlicker = new JCheckBox("Enable", this.editedShader.flickering);
        this.sFlicker = new JSlider(0, 1000, (int)(1000.0f * this.editedShader.flickeringFactor));
        this.cbFlicker.setBorder(null);
        this.cbFlicker.setFocusPainted(false);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, new JLabel(" Min"));
        ((Dictionary)hashtable).put(1000, new JLabel("Max "));
        this.sFlicker.setMinorTickSpacing(100);
        this.sFlicker.setMajorTickSpacing(500);
        this.sFlicker.setLabelTable(hashtable);
        this.sFlicker.setPaintTicks(true);
        this.sFlicker.setPaintLabels(true);
        UIUtils.linkComponents(this.cbFlicker, this.sFlicker, true);
        this.attachCheckBox(this.cbFlicker, "flickering");
        this.sFlicker.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.flickeringFactor = (float)UIGlowShaderSettings.this.sFlicker.getValue() / 1000.0f;
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(15, 10));
        jPanel.setBorder(new CompoundBorder(new TitledBorder(" Brightness Flickering "), new EmptyBorder(0, 10, 0, 0)));
        jPanel.add((Component)this.cbFlicker, "West");
        jPanel.add((Component)this.sFlicker, "Center");
        return jPanel;
    }

    private JComponent buildSubPane_general_persistenceAttenuation() {
        this.cbAttenuation = new JCheckBox("Enable", this.editedShader.attenuation);
        this.sAttenuation = new JSlider(1000, 6000, (int)(1000.0f * this.editedShader.attenuationFactor));
        this.cbAttenuation.setBorder(null);
        this.cbAttenuation.setFocusPainted(false);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(1000, new JLabel("Min."));
        ((Dictionary)hashtable).put(6000, new JLabel("Max."));
        this.sAttenuation.setMinorTickSpacing(500);
        this.sAttenuation.setMajorTickSpacing(2500);
        this.sAttenuation.setLabelTable(hashtable);
        this.sAttenuation.setPaintTicks(true);
        this.sAttenuation.setPaintLabels(true);
        UIUtils.linkComponents(this.cbAttenuation, this.sAttenuation, true);
        this.attachCheckBox(this.cbAttenuation, "attenuation");
        this.sAttenuation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.attenuationFactor = (float)UIGlowShaderSettings.this.sAttenuation.getValue() / 1000.0f;
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(15, 10));
        jPanel.setBorder(new CompoundBorder(new TitledBorder(" Persistence Diminution "), new EmptyBorder(0, 10, 0, 0)));
        jPanel.add((Component)this.cbAttenuation, "West");
        jPanel.add((Component)this.sAttenuation, "Center");
        return jPanel;
    }

    private JComponent buildMainBufferPanel() {
        this.cbMode = new JComboBox<String>(new String[]{" Fixed Size (preferred)", " Relative to window size"});
        this.sFactor = new JSlider(0, 1000, (int)(1000.0f * this.editedShader.bufferSizeFactor));
        this.cbAspect = new JCheckBox("Match Vectrex ratio", UIGlowShaderSettings.isFixedBufferVectrexRatio(this.editedShader));
        this.spWidth = new JSpinnerFix(new SpinnerNumberModel(this.editedShader.bufferFixedWidth, 25, 4096, 10));
        this.spHeight = new JSpinnerFix(new SpinnerNumberModel(this.editedShader.bufferFixedHeight, 32, 4096, 10));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, new JLabel("Min"));
        ((Dictionary)hashtable).put(500, new JLabel("0.5"));
        ((Dictionary)hashtable).put(1000, new JLabel("1.0"));
        this.sFactor.setMinorTickSpacing(100);
        this.sFactor.setMajorTickSpacing(500);
        this.sFactor.setLabelTable(hashtable);
        this.sFactor.setPaintTicks(true);
        this.sFactor.setPaintLabels(true);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                if (UIGlowShaderSettings.this.isEventHandled() && (n = ((Number)UIGlowShaderSettings.this.spHeight.getValue()).intValue()) != ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedHeight) {
                    ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedHeight = n;
                    if (UIGlowShaderSettings.this.cbAspect.isSelected()) {
                        int n2;
                        ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedWidth = n2 = (int)((float)n * 0.8f);
                        UIGlowShaderSettings.this.spWidth.setValue(n2);
                    }
                    UIGlowShaderSettings.this.fireShaderChanged();
                }
            }
        };
        final ChangeListener changeListener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                if (UIGlowShaderSettings.this.isEventHandled() && (n = ((Number)UIGlowShaderSettings.this.spWidth.getValue()).intValue()) != ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedWidth) {
                    ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedWidth = n;
                    if (UIGlowShaderSettings.this.cbAspect.isSelected()) {
                        int n2;
                        ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedHeight = n2 = (int)((float)n / 0.8f);
                        UIGlowShaderSettings.this.spHeight.setValue(n2);
                    }
                    UIGlowShaderSettings.this.fireShaderChanged();
                }
            }
        };
        this.spWidth.addChangeListener(changeListener2);
        this.spHeight.addChangeListener(changeListener);
        this.cbAspect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIGlowShaderSettings.this.cbAspect.isSelected() && UIGlowShaderSettings.this.isEventHandled() && !UIGlowShaderSettings.isFixedBufferVectrexRatio(UIGlowShaderSettings.this.editedShader)) {
                    ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferFixedWidth = -1;
                    changeListener2.stateChanged(null);
                }
            }
        });
        this.sFactor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (UIGlowShaderSettings.this.isEventHandled()) {
                    ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.bufferSizeFactor = (float)UIGlowShaderSettings.this.sFactor.getValue() / 1000.0f;
                    UIGlowShaderSettings.this.fireShaderChanged();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)this.cbMode, "Center");
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 10, 0, 10), new CompoundBorder(new TitledBorder(" Size Selection "), new EmptyBorder(0, 10, 10, 10))));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)this.sFactor, "Center");
        Borders.setTitleBorder(jPanel2, " Relative Size ");
        JPanel jPanel3 = new JPanel(new SpringLayout());
        jPanel3.add(new JLabel("Width"));
        jPanel3.add(this.spWidth);
        jPanel3.add(new JLabel("Height"));
        jPanel3.add(this.spHeight);
        UIUtils.makeCompactGrid(jPanel3, 2, 0, 0, 10, 10);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add((Component)this.cbAspect, "West");
        jPanel4.add((Component)jPanel3, "East");
        Borders.setTitleBorder(jPanel4, " Fixed Size ");
        final CardLayout cardLayout = new CardLayout(10, 10);
        final JPanel jPanel5 = new JPanel(cardLayout);
        jPanel5.add((Component)jPanel4, this.cbMode.getModel().getElementAt(0));
        jPanel5.add((Component)jPanel2, this.cbMode.getModel().getElementAt(1));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel5, UIGlowShaderSettings.this.cbMode.getSelectedItem().toString());
                if (actionEvent != null && UIGlowShaderSettings.this.isEventHandled()) {
                    boolean bl;
                    boolean bl2 = bl = UIGlowShaderSettings.this.cbMode.getSelectedIndex() == 0;
                    if (bl != ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.isBufferFixedSize) {
                        ((UIGlowShaderSettings)UIGlowShaderSettings.this).editedShader.isBufferFixedSize = bl;
                        UIGlowShaderSettings.this.fireShaderChanged();
                    }
                }
            }
        };
        this.cbMode.setSelectedIndex(this.editedShader.isBufferFixedSize ? 0 : 1);
        actionListener.actionPerformed(null);
        this.cbMode.addActionListener(actionListener);
        JPanel jPanel6 = new JPanel(new SpringLayout());
        jPanel6.add(jPanel);
        jPanel6.add(jPanel5);
        jPanel6.setBorder(Borders.EMPTY_10);
        UIUtils.makeCompactGrid(jPanel6, 1, 0, 0, 10, 0);
        return UIGlowShaderSettings.embed(jPanel6);
    }

    private JComponent buildMainKernelsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(15, 20, 10, 20));
        boolean bl = Arrays.equals(this.editedShader.getHorizonalKernel().getHalfMatrix(), this.editedShader.getVerticalKernel().getHalfMatrix());
        this.cbLinkKernels = new JCheckBox(" Link Horizontal & Vertical kernels ", bl);
        this.cbLinkKernels.setToolTipText("When checked, the vertical kernel is the same as the horizontal kernel.");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        jPanel2.add(this.buildKernelPane(this.cbLinkKernels, 0));
        jPanel2.add(this.buildKernelPane(this.cbLinkKernels, 1));
        JComponent jComponent = this.buildKernelModelPane();
        jPanel.add((Component)this.cbLinkKernels, "South");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jComponent, "North");
        return jPanel;
    }

    private JComponent buildKernelModelPane() {
        final JLabel jLabel = new JLabel("Parameter");
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.0, 1000.0, 0.1f);
        this.cbKernelPattern = new JComboBox<Pattern>(Pattern.values());
        this.spKernelParam = new JSpinnerFix(spinnerNumberModel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Pattern pattern = (Pattern)((Object)UIGlowShaderSettings.this.cbKernelPattern.getSelectedItem());
                jLabel.setText(pattern.getParamName());
                spinnerNumberModel.setStepSize(Float.valueOf(pattern.getParamStep()));
                UIGlowShaderSettings.this.spKernelParam.setValue(new Double(pattern.getParamDefault()));
            }
        };
        this.cbKernelPattern.setSelectedIndex(-1);
        this.cbKernelPattern.addActionListener(actionListener);
        this.cbKernelPattern.setSelectedItem((Object)Pattern.LINEAR);
        this.spKernelParam.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (UIGlowShaderSettings.this.isEventHandled() && UIGlowShaderSettings.this.feedKernels()) {
                    if (!UIGlowShaderSettings.this.cbLinkKernels.isSelected()) {
                        UIGlowShaderSettings.this.lockEvents();
                        UIGlowShaderSettings.this.kernelModels[1].kernelChanged();
                        UIGlowShaderSettings.this.unlockEvents();
                    }
                    UIGlowShaderSettings.this.kernelModels[0].kernelChanged();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel.add((Component)new JLabel("Type"), "West");
        jPanel.add((Component)this.cbKernelPattern, "Center");
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.spKernelParam, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "East");
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(" Filling Pattern "), new EmptyBorder(0, 10, 10, 10)));
        return jPanel3;
    }

    private JComponent buildKernelPane(final JCheckBox jCheckBox, int n) {
        JComboBox<String> jComboBox;
        final boolean bl = n == 0;
        final JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new CompoundBorder(new TitledBorder(bl ? " Horizontal " : " Vertical "), new EmptyBorder(0, 5, 5, 5)));
        CfgItemKernel cfgItemKernel = bl ? this.editedShader.getHorizonalKernel() : this.editedShader.getVerticalKernel();
        final KernelTableModel kernelTableModel = new KernelTableModel(cfgItemKernel);
        this.cbKernelSizes[n] = jComboBox = new JComboBox<String>(KERNEL_SIZES);
        this.kernelModels[n] = kernelTableModel;
        jComboBox.setSelectedIndex(cfgItemKernel.getHalfSize() - 1);
        final JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new JLabel("Kernel Size"), "Center");
        jPanel2.add(jComboBox, "East");
        JTable jTable = new JTable(kernelTableModel);
        jTable.setTableHeader(null);
        jTable.setShowGrid(false);
        jTable.setSelectionMode(0);
        jTable.setDefaultRenderer(Integer.class, new KernelTableOffsetRenderer());
        jTable.setDefaultRenderer(Float.class, new KernelTableValueRenderer());
        JComponent jComponent = new JLabel("-88 ");
        jComponent.setFont(jTable.getFont());
        int n2 = Math.max(24, jComponent.getPreferredSize().width);
        Object object = jTable.getColumnModel().getColumn(0);
        ((TableColumn)object).setMaxWidth(n2);
        ((TableColumn)object).setMinWidth(n2);
        ((TableColumn)object).setPreferredWidth(n2);
        ((TableColumn)object).setWidth(n2);
        jTable.setPreferredScrollableViewportSize(new Dimension(new JLabel((String)"8,8888888888888").getPreferredSize().width, 9 * jTable.getRowHeight()));
        jComponent = new JScrollPane(jTable);
        ((JScrollPane)jComponent).getViewport().setBackground(jTable.getBackground());
        final JLabel jLabel = new JLabel("Linked");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setHorizontalAlignment(0);
        jLabel.setEnabled(false);
        object = bl ? new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                if (UIGlowShaderSettings.this.isEventHandled()) {
                    bl = UIGlowShaderSettings.this.feedKernels();
                    if (jCheckBox.isSelected() && UIGlowShaderSettings.this.copyMatrixHtoV()) {
                        bl = true;
                    }
                }
                if (bl) {
                    kernelTableModel.kernelChanged();
                }
            }
        } : new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIGlowShaderSettings.this.isEventHandled() && UIGlowShaderSettings.this.feedKernels()) {
                    kernelTableModel.kernelChanged();
                }
            }
        };
        jComboBox.addActionListener((ActionListener)object);
        kernelTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (UIGlowShaderSettings.this.isEventHandled()) {
                    if (bl && jCheckBox.isSelected()) {
                        CfgItemKernel cfgItemKernel = kernelTableModel.getKernel();
                        UIGlowShaderSettings.this.editedShader.getVerticalKernel().setHalfMatrix((float[])cfgItemKernel.getHalfMatrix().clone());
                    }
                    UIGlowShaderSettings.this.fireShaderChanged();
                }
            }
        });
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jComponent, "Center");
        if (!bl) {
            ActionListener actionListener = new ActionListener((JScrollPane)jComponent){
                private final /* synthetic */ JScrollPane val$compList;
                {
                    this.val$compList = jScrollPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    jPanel.setVisible(false);
                    jPanel.removeAll();
                    if (jCheckBox.isSelected()) {
                        jPanel.add(jLabel);
                        if (UIGlowShaderSettings.this.isEventHandled() && actionEvent != null && UIGlowShaderSettings.this.copyMatrixHtoV()) {
                            kernelTableModel.kernelChanged();
                        }
                    } else {
                        jPanel.add((Component)jPanel2, "North");
                        jPanel.add((Component)this.val$compList, "Center");
                        UIGlowShaderSettings.this.lockEvents();
                        UIGlowShaderSettings.this.cbKernelSizes[1].setSelectedIndex(UIGlowShaderSettings.this.cbKernelSizes[0].getSelectedIndex());
                        UIGlowShaderSettings.this.unlockEvents();
                    }
                    jPanel.setVisible(true);
                }
            };
            actionListener.actionPerformed(null);
            jCheckBox.addActionListener(actionListener);
        }
        return jPanel;
    }

    private boolean feedKernels() {
        float f;
        boolean bl = this.cbLinkKernels.isSelected();
        CfgItemKernel cfgItemKernel = this.kernelModels[0].getKernel();
        CfgItemKernel cfgItemKernel2 = this.kernelModels[1].getKernel();
        int n = this.cbKernelSizes[0].getSelectedIndex() + 1;
        boolean bl2 = false;
        Pattern pattern = (Pattern)((Object)this.cbKernelPattern.getSelectedItem());
        float[] fArray = pattern.createKernel(n, f = ((Number)this.spKernelParam.getValue()).floatValue());
        if (!Arrays.equals(fArray, cfgItemKernel.getHalfMatrix())) {
            cfgItemKernel.setHalfMatrix(fArray);
            bl2 = true;
        }
        if (!bl) {
            float[] fArray2;
            int n2 = this.cbKernelSizes[1].getSelectedIndex() + 1;
            float[] fArray3 = fArray2 = n2 == n ? (float[])fArray.clone() : pattern.createKernel(n2, f);
            if (!Arrays.equals(fArray2, cfgItemKernel2.getHalfMatrix())) {
                cfgItemKernel2.setHalfMatrix(fArray2);
                bl2 = true;
            }
        }
        return bl2;
    }

    private final boolean copyMatrixHtoV() {
        CfgItemKernel cfgItemKernel = this.kernelModels[1].getKernel();
        float[] fArray = this.kernelModels[0].getKernel().getHalfMatrix();
        if (Arrays.equals(cfgItemKernel.getHalfMatrix(), fArray)) {
            return false;
        }
        cfgItemKernel.setHalfMatrix((float[])fArray.clone());
        return true;
    }

    private static final String getShaderDescription(String string) {
        return string == null || string.trim().length() == 0 ? DEFAULT_DESCRIPTION : string;
    }

    private static final String readShaderDescription(String string) {
        if (string != null && (string.length() == 0 || string.trim().equals(DEFAULT_DESCRIPTION))) {
            return null;
        }
        return string;
    }

    private static final boolean isFixedBufferVectrexRatio(CfgItemShaderGlow cfgItemShaderGlow) {
        return cfgItemShaderGlow.bufferFixedWidth == (int)((float)cfgItemShaderGlow.bufferFixedHeight * 0.8f);
    }

    private final synchronized void lockEvents() {
        ++this.eventsLock;
    }

    private final synchronized void unlockEvents() {
        this.eventsLock = Math.max(0, this.eventsLock - 1);
    }

    private final boolean isEventHandled() {
        return this.eventsLock == 0;
    }

    private final boolean hasBeenModified() {
        return this.hasBeenModified;
    }

    private final void setModified(boolean bl) {
        if (this.bUndo != null) {
            this.bUndo.setEnabled(bl);
        }
        if (bl && this.bOK != null) {
            this.bOK.setEnabled(true);
        }
        this.hasBeenModified = bl;
    }

    private final void fireShaderChanged() {
        if (this.isEventHandled()) {
            this.setModified(true);
            this.shaderChanged(this.editedShader);
        }
    }

    public static final void updateCheckBox(JCheckBox jCheckBox, boolean bl) {
        if (bl != jCheckBox.isSelected()) {
            jCheckBox.doClick(0);
        }
    }

    public final void attachCheckBox(final JCheckBox jCheckBox, String string) {
        Field field;
        try {
            field = CfgItemShaderGlow.class.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    field.setBoolean(UIGlowShaderSettings.this.editedShader, jCheckBox.isSelected());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                UIGlowShaderSettings.this.fireShaderChanged();
            }
        });
    }

    private static final JPanel embed(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jComponent, "North");
        return jPanel;
    }

    public static final void addHorizontalGlues(Container container, int n) {
        while (n-- > 0) {
            container.add(Box.createHorizontalGlue());
        }
    }

    private static final FileRequester getProfileChooser() {
        FileRequester fileRequester = profileReq;
        if (fileRequester == null) {
            File file = new File("data/shaders/", "user_defined_shader.glow");
            fileRequester = new FileRequester();
            fileRequester.setInitialFile(file, true);
            fileRequester.addFileExtensionFilter("ParaJVE glow shader files (*.glow)", ".glow");
            UIGlowShaderSettings.hookFileInfoPreview(fileRequester.getChooser());
            profileReq = fileRequester;
        } else {
            File file = fileRequester.getChooser().getSelectedFile();
            fileRequester.getChooser().setSelectedFile(null);
            fileRequester.setInitialFile(file, false);
        }
        return fileRequester;
    }

    private static void hookFileInfoPreview(JFileChooser jFileChooser) {
        JComponent[] jComponentArray = new JComponent[1];
        JComponent jComponent = UIGlowShaderSettings.createInfoPreview(jFileChooser, jComponentArray, 200);
        final JTextComponent jTextComponent = (JTextComponent)jComponentArray[0];
        int n = jFileChooser.getPreferredSize().width;
        jFileChooser.setAccessory(jComponent);
        Dimension dimension = jFileChooser.getPreferredSize();
        dimension.width = (3 * n + dimension.width) / 4;
        jFileChooser.setPreferredSize(dimension);
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    UIGlowShaderSettings.updatePreview(jTextComponent, file);
                }
            }
        });
        UIGlowShaderSettings.updatePreview(jTextComponent, jFileChooser.getSelectedFile());
    }

    private static JComponent createInfoPreview(JComponent jComponent, JComponent[] jComponentArray, int n) {
        JComponent jComponent2 = UIGlowShaderSettings.buildMainInfosPanel(false, jComponentArray);
        JTextComponent jTextComponent = (JTextComponent)jComponentArray[0];
        jTextComponent.setFont(jComponent.getFont());
        jTextComponent.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jTextComponent.setText(INVALID_DESCRIPTION);
        Dimension dimension = jComponent2.getPreferredSize();
        dimension.width = n;
        jComponent2.setPreferredSize(dimension);
        return jComponent2;
    }

    private static void updatePreview(JTextComponent jTextComponent, File file) {
        CfgItemShaderGlow cfgItemShaderGlow = null;
        if (file != null && file.isFile()) {
            try {
                cfgItemShaderGlow = UIGlowShaderSettings.loadShader(file);
            }
            catch (Exception exception) {}
        }
        UIGlowShaderSettings.updatePreview(jTextComponent, cfgItemShaderGlow);
    }

    private static void updatePreview(JTextComponent jTextComponent, CfgItemShaderGlow cfgItemShaderGlow) {
        String string = INVALID_DESCRIPTION;
        boolean bl = false;
        if (cfgItemShaderGlow != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 500);
            String string2 = "<font color=BLUE>";
            String string3 = "</font>";
            stringBuffer.append("<html>");
            stringBuffer.append("<b>General Information</b><hr>");
            stringBuffer.append("Shader passes : ").append(string2).append(cfgItemShaderGlow.passes).append(string3);
            stringBuffer.append("<br>Kernel size : ").append(string2).append(cfgItemShaderGlow.getHorizonalKernel().getFullSize()).append(" x ").append(cfgItemShaderGlow.getVerticalKernel().getFullSize()).append(string3);
            stringBuffer.append("<br>Buffer size : ").append(string2);
            if (cfgItemShaderGlow.isBufferFixedSize) {
                stringBuffer.append(cfgItemShaderGlow.bufferFixedWidth).append(" x ").append(cfgItemShaderGlow.bufferFixedHeight);
            } else {
                stringBuffer.append("window dependant");
            }
            stringBuffer.append(string3);
            String string4 = cfgItemShaderGlow.description;
            stringBuffer.append("<p><b>Description</b><hr>");
            if (string4 == null || string4.trim().length() == 0) {
                stringBuffer.append("<font color=#A0A0A0>no shader decription available</font>");
            } else {
                stringBuffer.append("<div align=\"justify\">");
                Utils.encodeHTML(string4.trim(), stringBuffer, true);
                stringBuffer.append("</div>");
            }
            string = stringBuffer.toString();
            bl = true;
        }
        jTextComponent.setBackground(bl ? UIManager.getColor("TextField.background") : null);
        jTextComponent.setEnabled(bl);
        jTextComponent.setText(string);
        jTextComponent.select(0, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KernelTableModel
    extends AbstractTableModel {
        private CfgItemKernel kernel;

        public KernelTableModel(CfgItemKernel cfgItemKernel) {
            this.kernel = cfgItemKernel;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.kernel.getFullSize();
        }

        @Override
        public Number getValueAt(int n, int n2) {
            float[] fArray = this.kernel.getHalfMatrix();
            if (n2 == 0) {
                return n - fArray.length + 1;
            }
            if (n >= fArray.length) {
                n = 2 * fArray.length - 2 - n;
            }
            return Float.valueOf(fArray[n]);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Integer.class : Float.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && n <= this.getRowCount() / 2;
        }

        @Override
        public synchronized void setValueAt(Object object, int n, int n2) {
            try {
                float f;
                float[] fArray = this.kernel.getHalfMatrix();
                if (n >= fArray.length) {
                    n = 2 * fArray.length - 2 - n;
                }
                if ((f = Float.parseFloat(object.toString())) != fArray[n]) {
                    fArray[n] = f;
                    this.kernelChanged();
                }
            }
            catch (Exception exception) {}
        }

        CfgItemKernel getKernel() {
            return this.kernel;
        }

        synchronized void cloneKernelMatrix() {
            this.kernel.setHalfMatrix((float[])this.kernel.getHalfMatrix().clone());
        }

        synchronized void setKernel(CfgItemKernel cfgItemKernel) {
            this.kernel = cfgItemKernel;
            this.kernelChanged();
        }

        void kernelChanged() {
            this.fireTableDataChanged();
        }
    }

    private class KernelTableOffsetRenderer
    extends DefaultTableCellRenderer {
        KernelTableOffsetRenderer() {
            super.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, false, false, n, n2);
            int n3 = jTable.getRowCount() / 2;
            if (n != n3) {
                this.setBackground(new Color(200, 255, 200));
            } else if (n == n3) {
                this.setBackground(new Color(200, 200, 200));
            }
            return this;
        }
    }

    private class KernelTableValueRenderer
    extends DefaultTableCellRenderer {
        private final NumberFormat floatFormatter;

        KernelTableValueRenderer() {
            super.setHorizontalAlignment(4);
            this.floatFormatter = NumberFormat.getNumberInstance();
            this.floatFormatter.setMinimumFractionDigits(2);
            this.floatFormatter.setMaximumFractionDigits(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, String.valueOf(this.floatFormatter.format(object)) + " ", bl, bl2, n, n2);
            if (!bl) {
                int n3 = jTable.getRowCount() / 2;
                this.setEnabled(n <= n3);
                if (n == n3) {
                    this.setBackground(new Color(230, 230, 230));
                } else {
                    this.setBackground(jTable.getBackground());
                }
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    private static class ListItemShader {
        private final CfgItemShaderGlow shader;
        private final String name;
        final boolean special;

        ListItemShader(String string, CfgItemShaderGlow cfgItemShaderGlow) {
            this.name = string;
            this.shader = cfgItemShaderGlow;
            this.special = true;
        }

        ListItemShader(File file, CfgItemShaderGlow cfgItemShaderGlow) {
            String string = file.getName();
            int n = string.lastIndexOf(46);
            this.name = n > 0 ? string.substring(0, n) : string;
            this.shader = cfgItemShaderGlow;
            this.special = false;
        }

        public CfgItemShaderGlow getShader() {
            return this.shader;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Pattern {
        PARABOLIC("Parabolic", "Factor", 0.5f, 0.025f){

            float[] createKernel(int n, float f) {
                return BlurShaderUtils.createParabolicKernel(n, f);
            }
        }
        ,
        LINEAR("Linear", "Slope", 1.0f, 0.25f){

            float[] createKernel(int n, float f) {
                return BlurShaderUtils.createLinearKernel(n, f);
            }
        }
        ,
        SQROOT("Square-Root", "Factor", 6.0f, 1.0f){

            float[] createKernel(int n, float f) {
                return BlurShaderUtils.createSquareRootKernel(n, f);
            }
        }
        ,
        GAUSSIAN("Gaussian", "Sigma", 2.0f, 0.02f){

            float[] createKernel(int n, float f) {
                return BlurShaderUtils.createGaussianKernel(n, f);
            }
        };

        private final String name;
        private final String paramName;
        private final float paramValue;
        private final float paramStep;

        private Pattern(String string2, String string3, float f, float f2) {
            this.name = string2;
            this.paramName = string3;
            this.paramValue = f;
            this.paramStep = f2;
        }

        abstract float[] createKernel(int var1, float var2);

        public String toString() {
            return " " + this.name + " ";
        }

        public float getParamDefault() {
            return this.paramValue;
        }

        public float getParamStep() {
            return this.paramStep;
        }

        public String getParamName() {
            return this.paramName;
        }
    }

    private static class TreeShaderRenderer
    extends DefaultTreeCellRenderer {
        private static final Font normFont = new JLabel().getFont();
        private static final Font boldFont = normFont.deriveFont(1);
        private final ImageIcon ICON_SHADER = JVEIcons.get("gears.png");

        private TreeShaderRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            String string = object.toString();
            char c = string.charAt(0);
            if (Character.isLowerCase(c)) {
                string = String.valueOf(Character.toUpperCase(c)) + string.substring(1);
            }
            super.getTreeCellRendererComponent(jTree, " " + string + " ", bl, bl2, bl3, n, bl4);
            if (bl3) {
                this.setIcon(this.ICON_SHADER);
            }
            if ((object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof ListItemShader && ((ListItemShader)object2).special) {
                this.setFont(boldFont);
            } else {
                this.setFont(normFont);
            }
            return this;
        }
    }
}

